/**
 * 
 */
package paye.eoy.bizrules.consolidated;

import hmrc.bizrules.AbstractHMRCBusinessRule;

/**
 * @author doug
 * 
 */
public class ECONAllowedRule extends AbstractHMRCBusinessRule {

    public static final String ECON_NOT_ALLOWED = "ECON not allowed";

    private boolean econAllowed = false;

    private boolean econPresent = false;

    public void setEconAllowed(final String value) {
        if (value.equals("true")) {
            econAllowed = true;
        }
    }

    public void setEcon(final String value) {
        econPresent = true;
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    public String[] getSubcodes() {
        return new String[] { ECON_NOT_ALLOWED };
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1" };
    }

    @Override
    protected void initializeEventBindings() {
        // no event bindings
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/EmployerDetails/ECON", "econ");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/ECON", "econ");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/ECONAllowed", "econAllowed");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/ECONAllowed", "econAllowed");
    }

    public void processRule() {
        if (econPresent && !econAllowed) {
            raiseQS3Error(ECON_NOT_ALLOWED);
        }
    }

}
