/**
 * 
 */
package paye.eoy.bizrules.consolidated;

import hmrc.bizrules.AbstractHMRCBusinessRule;
import paye.eoy.bizrules.p35.br0809.AbstractECONRequiredRule;

/**
 * @author doug
 * 
 */
public class ECONRequiredRule extends AbstractHMRCBusinessRule {

    public static final String ECON_REQUIRED = AbstractECONRequiredRule.REQUIRED;

    private boolean econRequired = false;

    private boolean econPresent = false;

    public void setEconRequired(final String value) {
        if (value.equals("true")) {
            econRequired = true;
        }
    }

    public void setEcon(final String value) {
        econPresent = true;
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    public String[] getSubcodes() {
        return new String[] { ECON_REQUIRED };
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected void initializeEventBindings() {
        // no event bindings
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/EmployerDetails/ECON", "econ");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/ECON", "econ");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/ECONRequired", "econRequired");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/ECONRequired", "econRequired");
    }

    public void processRule() {
        if (!econPresent && econRequired) {
            raiseQS3Error(ECON_REQUIRED);
        }
    }

}
