package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Doug
 */
public class NICCompensationOnASPPRule extends AbstractConsolidatedRule {

    public static final String COMP_GT_ASPP = "comp gt aspp";

    private BigDecimal asppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal aspp = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_ASPP, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPPcompensation", "asppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "aspp");
    }

    public void processRule() {
        if (asppCompensation.compareTo(aspp) > 0) {
            raiseQS3Error(COMP_GT_ASPP, new MonetaryDiscrepancy(asppCompensation, aspp));
        }
    }

    public final void setAspp(final String sap) {
        this.aspp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setAsppCompensation(final String sapCompensation) {
        this.asppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "handleError");
    }
}
