package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Doug
 */
public class NICCompensationOnOSPPRule extends AbstractConsolidatedRule {

    public static final String COMP_GT_OSPP = "comp gt ospp";

    private BigDecimal osppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal ospp = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_OSPP, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation", "osppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "ospp");
    }

    public void processRule() {
        if (osppCompensation.compareTo(ospp) > 0) {
            raiseQS3Error(COMP_GT_OSPP, new MonetaryDiscrepancy(osppCompensation, ospp));
        }
    }

    public final void setOspp(final String sap) {
        this.ospp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setOsppCompensation(final String sapCompensation) {
        this.osppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "handleError");
    }
}
