/*
 * Created on May 31, 2005
 * 
 * $Id: NICCompensationOnSAPRuleOriginal.java,v 1.9 2005/11/24 13:12:15 raustin
 * Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public class NICCompensationOnSAPRule extends AbstractConsolidatedRule {

    public static final String COMP_GT_SAP = "comp gt sap";

    private BigDecimal sapCompensation = BigDecimalUtil.ZERO;

    private BigDecimal sap = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_SAP, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAPcompensation", "sapCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAP", "sap");
    }

    public final void processRule() {
        if (sapCompensation.compareTo(sap) > 0) {
            raiseQS3Error(COMP_GT_SAP, new MonetaryDiscrepancy(sapCompensation, sap));
        }
    }

    public final void setSap(final String sap) {
        this.sap = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setSapCompensation(final String sapCompensation) {
        this.sapCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC" };
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAPcompensation", "handleError");
    }
}
