/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractNICCompensationOnSMPRuleOriginal.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

public class NICCompensationOnSMPRule extends AbstractConsolidatedRule {

    public static final String GT_SMP_RECOVERED = "greater than smp recovered";

    private BigDecimal smpCompensation = BigDecimalUtil.ZERO;

    private BigDecimal smpRecovered = BigDecimalUtil.ZERO;

    private final String[] subcodes = { GT_SMP_RECOVERED, DocumentError.FORMAT, DocumentError.MINVALUE, DocumentError.MAXVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "smpCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "smp");
    }

    public void processRule() {
        if (smpCompensation.compareTo(smpRecovered) > 0) {
            raiseQS3Error(GT_SMP_RECOVERED, new MonetaryDiscrepancy(smpCompensation, smpRecovered));
        }
    }

    public final void setSmp(final String sap) {
        this.smpRecovered = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setSmpCompensation(final String sapCompensation) {
        this.smpCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // no event bindings
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "handleError");
    }
}
