/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractNICCompensationOnSPPRuleOriginal.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Jaco
 */
public class NICCompensationOnSPPRule extends AbstractConsolidatedRule {

    public static final String COMP_GT_SPP = "comp gt spp";

    private BigDecimal sppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal spp = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_SPP, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/2" };
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "sppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "spp");
    }

    public void processRule() {
        if (sppCompensation.compareTo(spp) > 0) {
            raiseQS3Error(COMP_GT_SPP, new MonetaryDiscrepancy(sppCompensation, spp));
        }
    }

    public final void setSpp(final String sap) {
        this.spp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setSppCompensation(final String sapCompensation) {
        this.sppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "handleError");
    }
}
