/*
 * Created on Jun 1, 2005
 * 
 * $Id: NetStatutoryPaymentsRecoveredRule.java,v 1.3 2005/11/08 18:12:07 raustin
 * Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public class NetStatutoryPaymentsRecoveredRule extends AbstractConsolidatedRule {

    public static final String BAD_TOTAL = "bad total";

    private BigDecimal netStatutoryPaymentsRecovered = BigDecimalUtil.ZERO;

    private BigDecimal ssp = BigDecimalUtil.ZERO;

    private BigDecimal sap = BigDecimalUtil.ZERO;

    private BigDecimal smp = BigDecimalUtil.ZERO;

    private BigDecimal spp = BigDecimalUtil.ZERO;

    private BigDecimal ospp = BigDecimalUtil.ZERO;

    private BigDecimal aspp = BigDecimalUtil.ZERO;

    private BigDecimal smpCompensation = BigDecimalUtil.ZERO;

    private BigDecimal sapCompensation = BigDecimalUtil.ZERO;

    private BigDecimal sppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal osppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal asppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal nicHoliday = BigDecimalUtil.ZERO;

    private BigDecimal funding = BigDecimalUtil.ZERO;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected void initializeValueBindings() {

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered",
                "netStatutoryPaymentsRecovered");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered",
                "netStatutoryPaymentsRecovered");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSP", "ssp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSP", "ssp");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAP", "sap");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SAP", "sap");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "spp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPP", "spp");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "ospp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/OSPP", "ospp");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "aspp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPP", "aspp");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "smp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMP", "smp");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "smpCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMPcompensation", "smpCompensation");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "sppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPPcompensation", "sppCompensation");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation", "osppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/OSPPcompensation", "osppCompensation");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPPcompensation", "asppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPPcompensation", "asppCompensation");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAPcompensation", "sapCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SAPcompensation", "sapCompensation");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/NICholiday", "nicHoliday");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/NICholiday", "nicHoliday");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSPSMPSPPandSAPfunding", "funding");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSPSMPSPPandSAPfunding", "funding");

        // From 2011/12 we SPP became OSPP and ASPP
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSPSMPOSPPASPPandSAPfunding", "funding");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSPSMPOSPPASPPandSAPfunding", "funding");

    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered", "handleError");
    }

    public void processRule() {
        final BigDecimal calculatedTotal = ssp.add(smp).add(smpCompensation).add(spp).add(sppCompensation).add(ospp).add(
                osppCompensation).add(aspp).add(asppCompensation).add(sap).add(sapCompensation).add(nicHoliday).subtract(funding);

        if (netStatutoryPaymentsRecovered.compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, netStatutoryPaymentsRecovered));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35", "/IRenvelope/EndOfYearReturn/P35Amended" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    public void setNetStatutoryPaymentsRecovered(final String netStatutoryPaymentsRecovered) {
        this.netStatutoryPaymentsRecovered = BigDecimalUtil.toBigDecimal(netStatutoryPaymentsRecovered);
    }

    public void setNicHoliday(final String nicHoliday) {
        this.nicHoliday = BigDecimalUtil.toBigDecimal(nicHoliday);
    }

    public void setSap(final String sap) {
        this.sap = BigDecimalUtil.toBigDecimal(sap);
    }

    public void setSapCompensation(final String sapCompensation) {
        this.sapCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    public void setSmp(final String smp) {
        this.smp = BigDecimalUtil.toBigDecimal(smp);
    }

    public void setSmpCompensation(final String smpCompensation) {
        this.smpCompensation = BigDecimalUtil.toBigDecimal(smpCompensation);
    }

    public void setSpp(final String spp) {
        this.spp = BigDecimalUtil.toBigDecimal(spp);
    }

    public void setOspp(final String ospp) {
        this.ospp = BigDecimalUtil.toBigDecimal(ospp);
    }

    public void setAspp(final String aspp) {
        this.aspp = BigDecimalUtil.toBigDecimal(aspp);
    }

    public void setSppCompensation(final String sppCompensation) {
        this.sppCompensation = BigDecimalUtil.toBigDecimal(sppCompensation);
    }

    public void setOsppCompensation(final String osppCompensation) {
        this.osppCompensation = BigDecimalUtil.toBigDecimal(osppCompensation);
    }

    public void setAsppCompensation(final String asppCompensation) {
        this.asppCompensation = BigDecimalUtil.toBigDecimal(asppCompensation);
    }

    public void setSsp(final String ssp) {
        this.ssp = BigDecimalUtil.toBigDecimal(ssp);
    }

    public void setFunding(final String funding) {
        this.funding = BigDecimalUtil.toBigDecimal(funding);
    }
}
