/**
 * 
 */
package paye.eoy.bizrules.consolidated;

import paye.multiyear.TaxYear;

/**
 * @author doug
 * 
 */
public class NicHolidayClaimedRule extends AbstractPartTotalsRule {

    @Override
    protected String[] getPartTotalPaths() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotals/TotalNICholidayClaimed",
                "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalNICholidayClaimed" };
    }

    @Override
    protected String[] getP35Paths() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/TotalNICholidayClaimed",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/TotalNICholidayClaimed" };
    }

    @Override
    public boolean isActive() {
        return getTaxYear() == TaxYear.TAX_YEAR_0405;
    }
}
