/*
 * Created on January 24, 2006
 *
 * $Id: SPPRecoveredRuleOriginal.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
package paye.eoy.bizrules.consolidated;

import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public class OSPPRecoveredRuleOriginal extends AbstractRecoveredRuleConsolidated {

    public OSPPRecoveredRuleOriginal() {
        setRuleName("OSPPRecoveredRule");
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalOSPP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "handleError");
    }
}
