/*
 * Created on Jun 2, 2005
 * 
 * $Id: RevisedAmountNowPayableRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public class RevisedAmountNowPayableRule extends AbstractConsolidatedRule {

    public static final String BAD_TOTAL = "bad total";

    private BigDecimal cisDeductions = BigDecimalUtil.ZERO;

    private BigDecimal totalRemainingToPay = BigDecimalUtil.ZERO;

    private BigDecimal totalAfterCISdeductions = BigDecimalUtil.ZERO;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK,
            DocumentError.MAXVALUE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CISdeductions", "cisDeductions");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalRemainingToPay", "TotalRemainingToPay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalAfterCISdeductions",
                "TotalAfterCISdeductions");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CISdeductions", "cisDeductions");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalRemainingToPay",
                "TotalRemainingToPay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalAfterCISdeductions",
                "TotalAfterCISdeductions");
    }

    public void processRule() {
        final BigDecimal calculatedTotal = totalRemainingToPay.subtract(cisDeductions);

        if (totalAfterCISdeductions.compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, totalAfterCISdeductions));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35Amended", "/IRenvelope/EndOfYearReturn/P35" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    public void setCisDeductions(final String cisDeductions) {
        this.cisDeductions = BigDecimalUtil.toBigDecimal(cisDeductions);
    }

    public void setTotalAfterCISdeductions(final String totalAfterCISdeductions) {
        this.totalAfterCISdeductions = BigDecimalUtil.toBigDecimal(totalAfterCISdeductions);
    }

    public void setTotalRemainingToPay(final String totalRemainingToPay) {
        this.totalRemainingToPay = BigDecimalUtil.toBigDecimal(totalRemainingToPay);
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalAfterCISdeductions", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalAfterCISdeductions", "handleError");
    }
}
