/*
 * Created on May 31, 2005
 *
 * $Id: SMPRecoveredRuleOriginal.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
package paye.eoy.bizrules.consolidated;

import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public final class SMPRecoveredRuleOriginal extends AbstractRecoveredRuleConsolidated {

    public SMPRecoveredRuleOriginal() {
        setRuleName("SMPRecoveredRule");
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/2",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSMP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "handleError");
    }
}
