/*
 * Created on January 24, 2006
 *
 * $Id: SPPRecoveredRuleOriginal.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
package paye.eoy.bizrules.consolidated;

import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public class SPPRecoveredRuleOriginal extends AbstractRecoveredRuleConsolidated {

    public SPPRecoveredRuleOriginal() {
        setRuleName("SPPRecoveredRule");
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/2" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSPP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "handleError");
    }
}
