/*
 * Created on Jun 2, 2005
 * 
 * $Id: TotalAmountPayableRuleA.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;

/**
 * 
 */
public class TotalAmountPayableRuleA extends AbstractTotalAmountPayable {

    private String totalNICsTaxAndStudentLoanStr;

    private String netDeductionsStr;

    public void setNetDeductions(final String netDeductionsStr) {
        this.netDeductionsStr = netDeductionsStr;
    }

    public void setTotalNICsTaxAndStudentLoan(final String totalNICsTaxAndStudentLoanStr) {
        this.totalNICsTaxAndStudentLoanStr = totalNICsTaxAndStudentLoanStr;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5" };
    }

    @Override
    protected final void initializeLocalValueBindings() {

        // totalNICsTaxAndStudentLoan
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                "totalNICsTaxAndStudentLoan");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                "totalNICsTaxAndStudentLoan");

        // netDeductions
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetDeductions", "netDeductions");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetDeductions", "netDeductions");

    }

    @Override
    protected BigDecimal getCalculatedTotal() {
        final BigDecimal netDeductions = BigDecimalUtil.toBigDecimal(netDeductionsStr);
        final BigDecimal nicTaxAndStudentLoans = BigDecimalUtil.toBigDecimal(totalNICsTaxAndStudentLoanStr);
        return nicTaxAndStudentLoans.subtract(netDeductions);
    }

}
