package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;

public final class TotalAmountPayableRuleB extends AbstractTotalAmountPayable {

    private String subcontractorTaxStr;

    private String combinedLessStatutoryRecoveredStr;

    public void setCombinedLessStatutoryRecovered(final String value) {
        this.combinedLessStatutoryRecoveredStr = value;
    }

    public void setSubcontractorTax(final String value) {
        this.subcontractorTaxStr = value;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/2",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3", "http://www.govtalk.gov.uk/taxation/EOY-consolidated/3.1" };
    }

    @Override
    protected final void initializeLocalValueBindings() {
        // combinedLessStatutoryRecovered
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                "combinedLessStatutoryRecovered");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                "combinedLessStatutoryRecovered");

        // SubcontractorTax
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/SubcontractorTax", "subcontractorTax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/SubcontractorTax", "subcontractorTax");
    }

    @Override
    protected BigDecimal getCalculatedTotal() {
        final BigDecimal combinedAmounts = BigDecimalUtil.toBigDecimal(combinedLessStatutoryRecoveredStr);
        final BigDecimal subcontractorTax = BigDecimalUtil.toBigDecimal(subcontractorTaxStr);

        final BigDecimal result = combinedAmounts.add(subcontractorTax);

        return result;
    }
}
