/*
 * Created on May 31, 2005
 * 
 * $Id: TotalTaxAndNICRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public final class TotalTaxAndNICRule extends AbstractConsolidatedRule {

    public static final String BAD_TOTAL = "bad total";

    private BigDecimal totalTax = BigDecimalUtil.ZERO;

    private BigDecimal totalNIC = BigDecimalUtil.ZERO;

    private BigDecimal totalTaxAndNIC = BigDecimalUtil.ZERO;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setTotalNIC(final String totalNIC) {
        this.totalNIC = BigDecimalUtil.toBigDecimal(totalNIC);
    }

    public void setTotalTax(final String totalTax) {
        this.totalTax = BigDecimalUtil.toBigDecimal(totalTax);
    }

    public void setTotalTaxAndNIC(final String totalTaxAndNIC) {
        this.totalTaxAndNIC = BigDecimalUtil.toBigDecimal(totalTaxAndNIC);
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/TotalNIC", "totalNIC");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/TotalNIC", "totalNIC");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax", "totalTax");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalTaxAndNIC", "totalTaxAndNIC");
    }

    public void processRule() {
        final BigDecimal calculated = totalNIC.add(totalTax);

        if (totalTaxAndNIC.compareTo(calculated) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculated, totalTaxAndNIC));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalTaxAndNIC", "handleError");
    }
}
