/**
 * 
 */
package paye.eoy.bizrules.consolidated;

import paye.multiyear.TaxYear;

/**
 * @author doug
 * 
 */
public class TotalTaxCreditsPaidRule extends AbstractPartTotalsRule {

    @Override
    protected String[] getPartTotalPaths() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotals/TotalTaxCredits",
                "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalTaxCredits" };
    }

    @Override
    protected String[] getP35Paths() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TaxCredit",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TaxCredit" };
    }

    @Override
    public boolean isActive() {
        return getTaxYear() == TaxYear.TAX_YEAR_0405 || getTaxYear() == TaxYear.TAX_YEAR_0506;
    }
}
