/*
 * Created on 03-Jan-2006
 *
 * $Id: TotalTaxRuleA.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.consolidated;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;

/**
 * $Id: TotalTaxRuleA.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
public final class TotalTaxRuleA extends AbstractTotalTaxRule {

    private String subContractorTax = "";

    public void setSubContractorTax(final String value) {
        subContractorTax = value;
    }

    @Override
    protected void initializeLocalValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/SubcontractorTax", "subContractorTax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/SubcontractorTax", "subContractorTax");
    }

    @Override
    protected BigDecimal additionalTaxAdvances() {
        return BigDecimalUtil.toBigDecimal(subContractorTax);
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return new String[] { "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1",
                "http://www.govtalk.gov.uk/taxation/EOY-consolidated/1.5" };
    }

}
