/*
 * Created on Apr 30, 2005
 * 
 * $Id: IROfficeNumberRule.java,v 1.5 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.header;

import java.util.Collections;
import java.util.List;

import org.xml.sax.ErrorHandler;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import processingError.Location;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import xmldoc.DocumentLocation;

/**
 * This class extends AbstractBusinessRule instead of AbstractPAYEBusinessRule
 * because at the point it is invoked the processor has not yet seen the
 * submission and return types so it cannot decide whether to be active based on
 * them.
 */
public class IROfficeNumberRule extends AbstractPAYEBusinessRule {

    private String taxOfficeNumber = "";

    private boolean hasTaxOfficeNumber;

    private String keyType;

    private final String[] subcodes = { DocumentError.MANDATORY, DocumentError.VALUE, DocumentError.FORMAT };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setKey(final Attribute[] attribute) {
        for (final Attribute element : attribute) {
            if ("Type".equals(element.getLocalName())) {
                keyType = element.getValue();
            }
        }
    }

    public void setKey(final String value) {
        if ("TaxOfficeNumber".equals(keyType)) {
            hasTaxOfficeNumber = true;
            taxOfficeNumber = value;
        }
    }

    /**
     * The office number must be exactly three digits in length but cannot be
     * "000".
     */
    public void processRule() {
        final Location location = new DocumentLocation(0, 0, "TaxOfficeNumber");
        if (hasTaxOfficeNumber && taxOfficeNumber.length() > 0) {
            if (taxOfficeNumber.length() != 3) {
                raiseError(DocumentError.FORMAT, taxOfficeNumber, location);
            } else {
                try {
                    final int taxOfficeValue = Integer.parseInt(taxOfficeNumber);
                    if (taxOfficeValue <= 0) {
                        raiseError(DocumentError.VALUE, taxOfficeNumber, location);
                    }
                } catch (final NumberFormatException ex) {
                    raiseError(DocumentError.FORMAT, taxOfficeNumber, location);
                }
            }
        } else {
            // this has been added to support the old historic mappings
            raiseError(DocumentError.MANDATORY, location);
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope" };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        // no event bindings
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/IRheader/Keys/Key", "key");
    }

    /**
     * Default implementation.
     */
    public List<ErrorHandler> getErrorHandlerReferences() {
        return Collections.emptyList();
    }
}