/*
 * Created on Jun 6, 2005
 *
 * $Id: SubmissionTypeRuleOriginal.java,v 1.3 2006/05/26 10:45:42 dec Exp $
 */
package paye.eoy.bizrules.header;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.registry.DocumentEventDetail;

/**
 * @author Rob
 */
public class SubmissionTypeRuleOriginal extends AbstractPAYEBusinessRule {

    private BigDecimal cisDeductions = BigDecimalUtil.ZERO;

    public static final String NO_P14 = "no p14";

    public static final String NO_P35 = "no p35";

    public static final String P35_DEDUCTIONS_LTE_ZERO = "P35, but no p14s and CIS deductions <= 0";

    private boolean hasP14;

    private boolean hasP35;

    private final String[] subcodes = { NO_P14, NO_P35, P35_DEDUCTIONS_LTE_ZERO };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public SubmissionTypeRuleOriginal() {
        setRuleName("SubmissionTypeRule");
    }

    public void setCisDeductions(final String cisDeductions) {
        this.cisDeductions = BigDecimalUtil.toBigDecimal(cisDeductions);
    }

    public void onP14(final DocumentEventDetail detail) {
        hasP14 = true;
    }

    public void onP35(final DocumentEventDetail detail) {
        hasP35 = true;
    }

    public void processRule() {
        if (!hasP35) {
            raiseError(NO_P35);
        }
        if (hasP35 && !hasP14) {
            if (this.cisDeductions.compareTo(BigDecimalUtil.ZERO) <= 0) {
                raiseError(P35_DEDUCTIONS_LTE_ZERO);
            }
        }

    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P35", "onP35");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14", "onP14");
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CISdeductions", "cisDeductions");
    }

}
