/*
 * Created on 09-Jan-2006
 *
 * $Id$
 */
package paye.eoy.bizrules.helpers;

import java.math.BigDecimal;

/**
 * Adds values via the add method, to get the sum of the values call getTotal.
 */
public class BigDecimalTotalizer {

    private static final BigDecimal ZERO = new BigDecimal(0.0);

    private BigDecimal total = ZERO;

    public void add(final String valueStr) {
        final BigDecimal value = BigDecimalUtil.toBigDecimal(valueStr);
        total = total.add(value);
    }

    public BigDecimal getTotal() {
        return total;
    }
}
