/*
 * Created on 03-Jan-2006
 *
 * $Id$
 */
package paye.eoy.bizrules.helpers;

import java.math.BigDecimal;

/**
 * $Id$
 */
public final class BigDecimalUtil {

    public static final BigDecimal ZERO = new BigDecimal("0.00");

    private BigDecimalUtil() {
        // do nothing - prevent instantiation
    }

    /**
     * Try to convert the string to a BigDecimal value. If the string is not a
     * well formatted decimal value then will return BigDecimal(0.00).
     * 
     * Any zero value will always be returned as BigDecimal(0.00). This is so
     * that all zeros will compare the same since BigDecimal(0.00) is different
     * to BigDecimal(0).
     */
    public static BigDecimal toBigDecimal(final String string) {
        BigDecimal result;

        try {
            if (string == null || string.equals("")) {
                result = ZERO;
            } else if (string.equals("0.00") || string.equals("0")) {
                /*
                 * This is an optimization - zeros crop up a lot and this is
                 * faster than using the String constructor.
                 */
                result = ZERO;
            } else {
                result = new BigDecimal(string);
            }
        } catch (final Exception e) {
            result = ZERO;
        }

        if (ZERO.compareTo(result) == 0) {
            /*
             * We want to make sure that all zeros compare equal (using the
             * equals() method). 0, 0.0 and 0.00 are not equal under
             * BigDecimal.equals() because they have different scale, though
             * compareTo() will report them as being equal.
             */
            result = ZERO;
        }

        return result;
    }
}
