package paye.eoy.bizrules.helpers;

/**
 * @author doug
 * @since May 24, 2005
 */
public class Mod19 {
    public static final String table = "ABCDEFHJKLMNPQRTWXY";

    public static final int ECON = 37;

    public static final int SCON = 51;

    public static char calcECON(final String numericPart) {
        return calc(numericPart, ECON);
    }

    public static char calcSCON(final String numericPart) {
        return calc(numericPart, SCON);
    }

    private static char calc(final String numericPart, int checksum) {
        char result = 'Z';

        for (int i = 0; i < numericPart.length(); i++) {
            final int digit = Integer.parseInt(numericPart.substring(i, i + 1));
            checksum += digit * (8 - i);
        }

        final int remainder = checksum % 19;
        result = table.charAt(remainder);

        return result;
    }
}