/**
 * 
 */
package paye.eoy.bizrules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import xmldoc.DocumentError;

/**
 * Many rules for the paper channel need a DNA tolerance applied to the
 * whole-pounds check on numeric values. Unfortunately, the whole-pounds check
 * is bound up with the other number format checks in the schema types so all we
 * see is a FORMAT error if anything is wrong with the value. This helper
 * re-runs the regular expression checks on the value that caused the error to
 * distinguish between it not being whole pounds, and any other problem which
 * would have caused an error.
 * 
 * @author doug
 * 
 */
public class WholePoundsHelper {
    public static final String NOT_WHOLE_POUNDS = "not whole pounds";

    private static Pattern IR_DECIMAL_TYPE_PATTERN = Pattern.compile(RegularExressionPatterns.IR_DECIMAL_TYPE_REGEX);

    private static Pattern IR_WHOLE_POUNDS_PATTERN = Pattern.compile(RegularExressionPatterns.IR_WHOLE_POUNDS_REGEX);

    public static boolean checkWholePounds(final DocumentError documentError) {
        boolean result = false;
        if (documentError.getSubCode() == DocumentError.FORMAT) {
            final String valueInError = documentError.getValueInError().toString();

            final Matcher numericMatcher = IR_DECIMAL_TYPE_PATTERN.matcher(valueInError);

            /*
             * First check that the value is a valid numeric value (according to
             * the regex taken from the schema). If not, we'll fall through and
             * just raise the error as normal.
             */
            if (numericMatcher.matches()) {
                final Matcher m = IR_WHOLE_POUNDS_PATTERN.matcher(documentError.getValueInError().toString());
                if (!m.matches()) {
                    result = true;
                }
            }
        }
        return result;
    }
}
