/*
 * Created on 06-Dec-2005
 *
 * $Id: AbstractP14CountCountCheck.java,v 1.6 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p14;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ValueBinder;

/**
 * $Id: AbstractP14CountCountCheck.java,v 1.6 2006/08/10 15:19:16 dec Exp $
 */
public abstract class AbstractP14CountCountCheck extends AbstractPAYEBusinessRule {

    public static final String BAD_COUNT = "bad count";

    public static final String MISSING = "count missing";

    private String suppliedP14CountStr = "";

    private int calculatedP14Count;

    private boolean hasP14Count;

    private final String[] subcodes = { BAD_COUNT, MISSING, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setP14Count(final String value) {
        suppliedP14CountStr = value;
        hasP14Count = true;
    }

    public void setP14(final String value) {
        calculatedP14Count = calculatedP14Count + 1;
    }

    private void reset() {
        calculatedP14Count = 0;
        suppliedP14CountStr = "";
        hasP14Count = false;
    }

    public void processRule() {
        if (hasP14Count == true) {
            try {
                final int suppliedP14Count = Integer.parseInt(suppliedP14CountStr);

                doRuleChecks(suppliedP14CountStr);

                if (calculatedP14Count != suppliedP14Count) {
                    // does not match actual number of P14s submitted
                    raiseError(BAD_COUNT, "" + calculatedP14Count);
                }
            } catch (final NumberFormatException e) {
                // do nothing, the schema will pick up this error.
            }
        } else {
            raiseError(MISSING);
        }

        reset();
    }

    @Override
    protected void initializeValueBindings() {
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended", "P14");
        binder.add("/IRenvelope/EndOfYearReturn/P14", "P14");
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    protected abstract void doRuleChecks(String value);

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }
}
