package paye.eoy.bizrules.p14;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.registry.DocumentEventDetail;

/**
 * This rule checks that a P35 doesn't exist if "I" am a P14Part return.
 * 
 * @author Rob
 */
public class CheckNoP35InP14PartSubmissionRule extends AbstractPAYEBusinessRule {

    public static final String _1 = "hasP35inP14";

    private boolean hasP35;

    private final String[] subcodes = { _1 };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void onP35(final DocumentEventDetail detail) {
        hasP35 = true;
    }

    public void processRule() {
        if (hasP35) {
            raiseError(_1);
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART, };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P35Amended", "onP35");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P35", "onP35");
    }

    @Override
    protected void initializeValueBindings() {
        // do nothing
    }

}
