/**
 * 
 */
package paye.eoy.bizrules.p14;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author bill
 * 
 */
public class EarningsUAPtoUELRule extends AbstractP14BusinessRule {

    private final String[] subcodes = { WholePoundsHelper.NOT_WHOLE_POUNDS, MUST_BE_ZERO_FOR_NI_CATEGORY, DocumentError.FORMAT,
            DocumentError.BLANK, DocumentError.MINVALUE };

    public static final String MUST_BE_ZERO_FOR_NI_CATEGORY = "must be zero for ni category";

    private BigDecimal earnings = BigDecimalUtil.ZERO;

    private String niCategory = "";

    protected String getNICategoryForWhichValueMustBeZero() {
        return "X";
    }

    @Override
    protected void reset() {
        setEarnings("0");
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/NICs", "/IRenvelope/EndOfYearReturn/P14Amended/NICs" };
    }

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected void initializeEventBindings() {
        final ErrorBinder binder = getErrorBinder();
        final String[] errorHandlers = new String[] { "distinguishWholePoundsError", "handleError" };
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/UAPtoUEL", errorHandlers);
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/UAPtoUEL", errorHandlers);
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/UAPtoUEL", "earnings");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/UAPtoUEL", "earnings");
    }

    public void processRule() {
        checkSubrule4();
    }

    private void checkSubrule4() {
        if (getNiCategory().length() > 0 && getNICategoryForWhichValueMustBeZero().indexOf(getNiCategory()) != -1) {
            if (getEarnings().compareTo(BigDecimalUtil.ZERO) != 0) {
                raiseError(MUST_BE_ZERO_FOR_NI_CATEGORY, getEarnings());
            }
        }
    }

    public void setEarnings(final String earnings) {
        this.earnings = BigDecimalUtil.toBigDecimal(earnings);
    }

    protected BigDecimal getEarnings() {
        return earnings;
    }

    protected void setNiCategory(final String niCategory) {
        this.niCategory = niCategory;
    }

    protected String getNiCategory() {
        return niCategory;
    }

    public void setNICs(final Attribute[] attribute) {

        for (final Attribute element : attribute) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                setNiCategory(value);
            }
        }
    }

}
