/**
 * 
 */
package paye.eoy.bizrules.p14;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class EmployeeAddressLineRule extends AbstractP14BusinessRule {

    private String addressLine = "";

    private final String[] subcodes = { DocumentError.FORMAT };

    @Override
    protected void reset() {
        addressLine = "";
    }

    /**
     * The character set restriction was only added in 0708 so don't apply to
     * previous years
     */
    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/Address/Line", "/IRenvelope/EndOfYearReturn/P14Amended/Address/Line" };
    }

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/Address/Line", "addressLine");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/Address/Line", "addressLine");
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/Address/Line", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/Address/Line", "handleError");
    }

    /**
     * Because this rule is taking over from the schema check (see class javadoc
     * comment) we want to suppress any errors coming from the parser. For that
     * reason we bind this callback to errors on the Fore element and simply
     * return true to indicate that we have consumed them.
     * 
     * @return true in order to indicate we have consumed the error.
     */
    @Override
    public boolean handleError(final DocumentError error) {
        if (error.getSubCode().equals(DocumentError.FORMAT)) {
            return true;
        } else {
            return false;
        }
    }

    public void processRule() {
        if (getAddressLine().length() == 0) {
            raiseError(DocumentError.BLANK);
        } else {
            checkCharacterSetA(getAddressLine());
        }
    }

    public void setAddressLine(final String addressLine) {
        this.addressLine = addressLine;
    }

    public String getAddressLine() {
        return addressLine;
    }

}
