/*
 * Created on May 24, 2005
 *
 * $Id: EmployeeDOBRule.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 */
package paye.eoy.bizrules.p14;

import java.text.ParseException;
import java.util.Date;

import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.DateHelper;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public final class EmployeeDOBRule extends AbstractP14BusinessRule {
    public static final String REQUIRED = "required";

    public static final String TOO_LATE = "too late";

    private final String[] subcodes = { REQUIRED, DocumentError.FORMAT, DocumentError.BLANK, TOO_LATE };

    private boolean formatErrorSeen = false;

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public final void processRule() {
        if (!formatErrorSeen && getDateOfBirth().length() > 0) {
            try {
                final Date dob = DateHelper.parseDate(getDateOfBirth());
                if (dob.after(DateHelper.today())) {
                    raiseError(TOO_LATE, getDateOfBirth());
                }
            } catch (final ParseException e) {
                // ignore the parse error - the schema will have generated a
                // format error in this case and it is a lot more strict on
                // format checking.
            }
        }

        /* If DOB is misssing then NINO must be present */
        if ("".equals(getDateOfBirth()) && "".equals(getNino())) {
            raiseError(REQUIRED, getDateOfBirth());
        }
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14Amended", "/IRenvelope/EndOfYearReturn/P14", };
    }

    @Override
    protected void reset() {
        // do nothing
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14/DOB", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/DOB", "handleError");
    }

    @Override
    public boolean handleError(final DocumentError documentError) {
        if (DocumentError.FORMAT.equals(documentError.getSubCode())) {
            formatErrorSeen = true;
        }
        return super.handleError(documentError);
    }
}
