/*
 * Created on May 24, 2005
 *
 * $Id: AbstractEmployeeGenderRule.java,v 1.4 2006/06/09 11:15:06 dec Exp $
 */
package paye.eoy.bizrules.p14;

import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.Attribute;
import xmldoc.DocumentError;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Rob
 */

public class EmployeeGenderRule extends AbstractP14BusinessRule {

    public static final String MISSING = "missing";

    private String gender = "";

    private Collection<String> categories;

    public static final String MUST_NOT_BE_MALE = "must not be male";

    private static final String[] subcodes = {MISSING, DocumentError.VALUE, DocumentError.BLANK, MUST_NOT_BE_MALE};

    private static final Map<TaxYear, String> categoryCodesByYear = new HashMap<TaxYear, String>();

    static {
        for (TaxYear year : TaxYear.allActive()) {
            categoryCodesByYear.put(year, "BEOT");
        }
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public EmployeeGenderRule() {
        setRuleName("EmployeeGenderRule");
    }

    public void processRule() {
        processValidCategoriesForGender();

        if (getGender().equals("") && getNino().equals("")) {
            raiseError(MISSING, "");
        }
    }

    protected void processValidCategoriesForGender() {
        TaxYear year = getTaxYear();
        String validCategoriesForMale = categoryCodesByYear.get(year);

        if (validCategoriesForMale != null) {
            for (final String category : categories) {
                // If the category is not a single character then this will get
                // trapped elsewhere.
                if (category.length() == 1) {
                    if (validCategoriesForMale.indexOf(category.charAt(0)) != -1 && "male".equals(getGender())) {
                        raiseError(MUST_NOT_BE_MALE);
                    }
                }
            }
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[]{"/IRenvelope/EndOfYearReturn/P14Amended", "/IRenvelope/EndOfYearReturn/P14"};
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[]{ReturnType.ORIGINAL, ReturnType.AMENDED};
    }

    @Override
    protected void initializeEventBindings() {
        // no bindings by default
    }

    public final void setNICs(final Attribute[] attributes) {
        for (final Attribute element : attributes) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                categories.add(value);
            }
        }
    }

    protected void initializeLocalValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
    }

    @Override
    protected void initializeValueBindings() {
        initializeLocalValueBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/Sex", "gender");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/Sex", "gender");
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/Sex", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/Sex", "handleError");
    }

    public String getGender() {
        return gender;
    }

    public void setGender(final String gender) {
        this.gender = gender;
    }

    @Override
    protected final void reset() {
        categories = new ArrayList<String>();
        gender = "";
    }
}
