/*
 * Created on 30-May-2005
 * 
 * $Id: P14CountCheckRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14;

import paye.eoy.types.SubmissionType;
import bizrules.binding.ValueBinder;

/**
 * for a complete submission
 */
public abstract class P14CountCheckRule extends AbstractP14CountCountCheck {

    public P14CountCheckRule() {
        setRuleName("P14CountCheckRule");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected void initializeValueBindings() {
        super.initializeValueBindings();
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14Count", "P14Count");
    }

}
