/*
 * Created on 02-Feb-2006
 *
 * $Id: P14CountCheckRuleOriginal.java,v 1.2 2006/05/26 10:45:42 dec Exp $
 */
package paye.eoy.bizrules.p14;

import paye.eoy.types.ReturnType;
import bizrules.binding.ValueBinder;

/**
 * $Id: P14CountCheckRuleOriginal.java,v 1.2 2006/05/26 10:45:42 dec Exp $
 */
public class P14CountCheckRuleOriginal extends P14CountCheckRule {

    private static Double ZERO = new Double("0.00");

    public static final String SUPPLIED_COUNT_ZERO = "supplied count zero";

    private final String[] subcodes = { SUPPLIED_COUNT_ZERO };

    private Double cisDeductions = null;

    @Override
    public String[] getSubcodes() {
        final String[] array1 = super.getSubcodes();
        final String[] array2 = subcodes;

        return combine(array1, array2);
    }

    @Override
    protected void doRuleChecks(final String suppliedP14CountStr) throws NumberFormatException {
        final int suppliedP14Count = Integer.parseInt(suppliedP14CountStr);
        if (suppliedP14Count == 0) {
            /*
             * Rule was introduced at 10/11 to allow the P14count to be zero if
             * the CIS Deductions are greater than zero. For earlier years there
             * is no CISdeductions field so the value of cisDeductions will be
             * null. Using this fact means we don't have to do an explicit year
             * check.
             */
            if (cisDeductions == null || cisDeductions.compareTo(ZERO) <= 0) {
                raiseError(SUPPLIED_COUNT_ZERO, suppliedP14CountStr);
            }
        }
    }

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected void initializeValueBindings() {
        super.initializeValueBindings();
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CISdeductions", "cisDeductions");
    }

    public void setCisDeductions(final String val) {
        try {
            cisDeductions = new Double(val);
        } catch (final NumberFormatException ex) {
            // suppress - should be caught by schema
        }
    }
}
