/*
 * Created on 02-Feb-2006
 *
 * $Id: P14CountFormatCheckRule.java,v 1.2 2006/05/26 10:45:42 dec Exp $
 */
package paye.eoy.bizrules.p14;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.binding.ValueBinder;

/**
 * $Id: P14CountFormatCheckRule.java,v 1.2 2006/05/26 10:45:42 dec Exp $
 */
public class P14CountFormatCheckRule extends AbstractPAYEBusinessRule {

    public static final String BAD_FORMAT = "bad format";

    private String suppliedP14CountStr = "";

    private final String[] subcodes = { BAD_FORMAT, DocumentError.FORMAT, DocumentError.INVALID, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setP14Count(final String value) {
        suppliedP14CountStr = value;
    }

    public P14CountFormatCheckRule() {
        setRuleName("P14CountCheckRule");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected void initializeValueBindings() {
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14Count", "P14Count");
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14Count", "handleError");
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    public void processRule() {
        // must be 1 to 7 characters long.. YES it should be in the schema but
        // is not !
        if (suppliedP14CountStr.length() > 7) {
            raiseError(BAD_FORMAT, suppliedP14CountStr);
        }
    }
}
