/**
 * $Id$
 */
package paye.eoy.bizrules.p14;

import paye.multiyear.TaxYear;
import xmldoc.DocumentEventType;
import bizrules.AbstractElementProcessor;
import bizrules.binding.EventBinder;
import bizrules.binding.ValueBinder;
import bizrules.registry.DocumentEventDetail;

/**
 * This object collects the P14 details which identify the P14 in which an error
 * occurred. Collecting the details in this one place is an optimisation so that
 * each P14 business rule does not need to register for these values
 * individually. This greatly reduces the overall registration time.
 * 
 * @author Douglas Clinton
 * @since Feb 24, 2006
 * 
 */
public class P14IdentifierCollector extends AbstractElementProcessor {

    private static final ThreadLocal<P14Identifier> p14Identifier = new ThreadLocal<P14Identifier>();

    static {
        p14Identifier.set(new P14Identifier());
    }

    public P14IdentifierCollector() {
    }

    /**
     * Bind in the identify details which are used for the locator on P14
     * errors.
     */
    @Override
    protected void initializeValueBindings() {
        final ValueBinder valueBinder = getValueBinder();
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14/Name/Sur", "surname");
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14/DOB", "dateOfBirth");
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14/NINO", "nino");
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14Amended/Name/Sur", "surname");
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14Amended/DOB", "dateOfBirth");
        valueBinder.add("/IRenvelope/EndOfYearReturn/P14Amended/NINO", "nino");
    }

    @Override
    protected void initializeEventBindings() {
        final EventBinder eventBinder = getEventBinder();
        eventBinder.add("/IRenvelope/EndOfYearReturn/P14Amended", "startP14", DocumentEventType.startElement);
        eventBinder.add("/IRenvelope/EndOfYearReturn/P14", "startP14", DocumentEventType.startElement);
        eventBinder.add("/IRenvelope/EndOfYearReturn/P14Amended", "endP14", DocumentEventType.endElement);
        eventBinder.add("/IRenvelope/EndOfYearReturn/P14", "endP14", DocumentEventType.endElement);
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return TaxYear.getUniqueNamespaces();
    }

    public static P14Identifier getP14Identifier() {
        return p14Identifier.get();
    }

    public final void startP14(final DocumentEventDetail detail) {
        final P14Identifier identifier = new P14Identifier();
        p14Identifier.set(identifier);
        getErrorCollector().setErrorExtraInfo(identifier);
    }

    public final void endP14(final DocumentEventDetail detail) {
        getErrorCollector().setErrorExtraInfo(null);
    }

    public final void setSurname(final String surname) {
        getP14Identifier().setSurname(surname);
    }

    public final void setDateOfBirth(final String value) {
        getP14Identifier().setDateOfBirth(value);
    }

    public final void setNino(final String value) {
        getP14Identifier().setNino(value);
    }
}
