/**
 * @author Rob
 */
package paye.eoy.bizrules.p14;

import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public final class P14StLoanDeductionsThisEmpRule extends AbstractP14BusinessRule {

    private final String[] subcodes = { DocumentError.MINVALUE, DocumentError.MAXVALUE, DocumentError.FORMAT,
            WholePoundsHelper.NOT_WHOLE_POUNDS, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void processRule() {
        // Do nothing - rule is only here to trap Format errors and map them
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/StLoan",
                "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/StLoan" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
    }

    @Override
    protected void initializeErrorBindings() {
        final String[] errorHandlers = new String[] { "distinguishWholePoundsError", "handleError" };

        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/StLoan", errorHandlers);
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/StLoan", errorHandlers);
    }

    @Override
    protected void reset() {
        // do nothing
    }

}
