/*
 * Created on May 27, 2005
 * 
 * $Id: SMPRule.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Rob
 */
public final class SMPRule extends AbstractP14BusinessRule {

    public static final String MUST_BE_ZERO_FOR_MALES = "must be zero";

    public static final String GENDER_REQUIRED = "gender required";

    private static final String MALE = "male";

    private String smp = "";

    private String gender = "";

    private final String[] subcodes = { MUST_BE_ZERO_FOR_MALES, GENDER_REQUIRED, DocumentError.FORMAT, DocumentError.MINVALUE,
            DocumentError.MAXVALUE, DocumentError.UNKNOWN, DocumentError.BLANK, DocumentError.MANDATORY, DocumentError.INVALID };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void processRule() {
        if (!smp.equals("")) {
            final BigDecimal smpNumeric = BigDecimalUtil.toBigDecimal(smp);
            if (smpNumeric != null && smpNumeric.compareTo(BigDecimalUtil.ZERO) != 0) {
                if (gender.equals("")) {
                    // Non-zero SMP means gender must be present
                    raiseError(GENDER_REQUIRED, smp);
                } else if (gender.equals(MALE)) {
                    // Non-zero SMP means gender cannot be 'male'
                    raiseError(MUST_BE_ZERO_FOR_MALES, smp);
                }
            }

        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/SMP", "/IRenvelope/EndOfYearReturn/P14Amended/SMP" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/Sex", "gender");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/Sex", "gender");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/SMP", "smp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/SMP", "smp");
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void reset() {
        smp = "";
        gender = "";
    }

    public void setSmp(final String smp) {
        this.smp = smp;
    }

    public void setGender(final String gender) {
        this.gender = gender;
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/SMP", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/SMP", "handleError");
    }

}
