/**
 * 
 */
package paye.eoy.bizrules.p14;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * From 07/08 onwards the allowed characters in the Works Number has been
 * restricted to Character Set A. However, this is not checked in the schema so
 * we need a rule for it.
 * 
 * @author doug
 * 
 */
public class WorksNumberRule extends AbstractP14BusinessRule {
    private static final String WORKS_NUMBER_PATH_AMENDED = "/IRenvelope/EndOfYearReturn/P14/WkNo";

    private static final String WORK_NUMBER_PATH = "/IRenvelope/EndOfYearReturn/P14Amended/WkNo";

    private String worksNumber = "";

    private final String[] subcodes = { DocumentError.FORMAT };

    @Override
    protected void reset() {
        worksNumber = "";
    }

    /**
     * The character set restriction was only added in 0708 so don't apply to
     * previous years
     */
    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { WORK_NUMBER_PATH, WORKS_NUMBER_PATH_AMENDED };
    }

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add(WORK_NUMBER_PATH, "worksNumber");
        getValueBinder().add(WORKS_NUMBER_PATH_AMENDED, "worksNumber");
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add(WORK_NUMBER_PATH, "handleError");
        getErrorBinder().add(WORKS_NUMBER_PATH_AMENDED, "handleError");
    }

    /**
     * Because this rule is taking over from the schema check (see class javadoc
     * comment) we want to suppress any errors coming from the parser. For that
     * reason we bind this callback to errors on the Fore element and simply
     * return true to indicate that we have consumed them.
     * 
     * @return true in order to indicate we have consumed the error.
     */
    @Override
    public boolean handleError(final DocumentError error) {
        if (error.getSubCode().equals(DocumentError.FORMAT)) {
            return true;
        } else {
            return false;
        }
    }

    public void processRule() {
        if (getWorksNumber().length() == 0) {
            raiseError(DocumentError.FORMAT);
        } else {
            checkCharacterSetA(getWorksNumber());
        }
    }

    public String getWorksNumber() {
        return worksNumber;
    }

    public void setWorksNumber(final String worksNumber) {
        this.worksNumber = worksNumber;
    }

}
