/*
 * Created on May 25, 2005
 * 
 * $Id: AbstractAggregationRule.java,v 1.2 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.aggregation;

import java.util.ArrayList;
import java.util.Collection;

import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import paye.eoy.types.Nic;
import paye.eoy.types.NicBean;
import paye.eoy.types.ReturnType;
import xmldoc.Attribute;

/**
 * @author Rob
 */
public abstract class AbstractAggregationRule extends AbstractP14BusinessRule {

    private NicBean nic;

    private Collection<NicBean> nicsCollection;

    protected abstract void localReset();

    @Override
    protected void reset() {
        localReset();
        nicsCollection = new ArrayList<NicBean>();
    }

    public void setContributionLineA(final String value) {
        nic.setContributionLineA(value);
    }

    public void setContributionLineB(final String value) {
        nic.setContributionLineB(value);
    }

    public void setContributionLineC(final String value) {
        nic.setContributionLineC(value);
    }

    public void setBoth(final String value) {
        nic.setBoth(value);
    }

    public void setEmp(final String value) {
        nic.setEmp(value);
    }

    public void setUapToUel(final String value) {
        nic.setUapToUEL(value);
    }

    public void setNICs(final Attribute[] attribute) {
        nicsCollection.add(nic = new NicBean());
        for (final Attribute element : attribute) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                nic.setNiCategory(value);
            }
        }
    }

    protected abstract void initializeLocalValueBindings();

    @Override
    protected final void initializeValueBindings() {
        initializeLocalValueBindings();

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/AtLEL", "ContributionLineA");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/LELtoET", "ContributionLineB");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/LELtoPT", "ContributionLineB");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUEL", "ContributionLineC");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/UAPtoUEL", "UapToUel");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Emp", "emp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Emp", "emp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Both", "both");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "both");

        /*
         * At 0910 the ETtoUEL field was supplanted by the ETtoUAP field. The
         * new UAPtoUEL was introduced but does not play a part in the
         * determination of an aggregation case.
         */
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUAP", "ContributionLineC");
        // And in 2011 it changed name to PTtoUAP
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/PTtoUAP", "ContributionLineC");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/AtLEL", "ContributionLineA");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/LELtoET", "ContributionLineB");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/LELtoPT", "ContributionLineB");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUEL", "ContributionLineC");

        /*
         * See above
         */
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUAP", "ContributionLineC");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/PTtoUAP", "ContributionLineC");
    }

    protected abstract void processRule(Nic nics);

    public final void processRule() {
        final NicBean[] nics = getNics();

        final Aggregation agregation = AggregationFactory.getInstance(getTaxYear());

        if (!agregation.isAggregation(nics)) {
            for (final NicBean element : nics) {
                processRule(element);
            }
        }
    }

    private NicBean[] getNics() {
        final NicBean[] nics = new NicBean[nicsCollection.size()];
        nicsCollection.toArray(nics);
        return nics;
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14", "/IRenvelope/EndOfYearReturn/P14Amended" };
    }

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }
}