/*
 * Created on 07-Jan-2006
 *
 * $Id: AggregationC.java,v 1.1 2006/06/08 13:49:07 dec Exp $
 */
package paye.eoy.bizrules.p14.aggregation;

import java.util.Map;

/**
 * Agregation for 0506 and 0607
 */
class AggregationC extends AbstractAggregation {

    /**
     * In 0607 a new aggregation combination was added to the rules.
     */
    @Override
    protected AggregationEarningsCombination[] getEarningsCombinations() {
        return new AggregationEarningsCombination[]{
                // 
                new AggregationEarningsCombination("NNN", "YYN"), new AggregationEarningsCombination("NNY", "YNN"),
                new AggregationEarningsCombination("NNY", "YNY"),
                new AggregationEarningsCombination("NYY", "YNN"),
                new AggregationEarningsCombination("NYY", "YNY"),
                new AggregationEarningsCombination("NNY", "YYN"),
                new AggregationEarningsCombination("NNN", "YNY"),
                new AggregationEarningsCombination("NNN", "YNN"),
                new AggregationEarningsCombination("NNN", "NYN"),
                // the following is the inverse of the above
                new AggregationEarningsCombination("YYN", "NNN"), new AggregationEarningsCombination("YNN", "NNY"),
                new AggregationEarningsCombination("YNY", "NNY"), new AggregationEarningsCombination("YNN", "NYY"),
                new AggregationEarningsCombination("YNY", "NYY"), new AggregationEarningsCombination("YYN", "NNY"),
                new AggregationEarningsCombination("YNY", "NNN"), new AggregationEarningsCombination("YNN", "NNN"),
                new AggregationEarningsCombination("NYN", "NNN")};
    }

    static final AggregationNicCategoryCombination[] NIC_CATEGORY_COMBINATIONS_0607 = new AggregationNicCategoryCombination[]{
            new AggregationNicCategoryCombination('A', "BDEFGHKNORT"), new AggregationNicCategoryCombination('D', "BEGHKNORT"),
            new AggregationNicCategoryCombination('E', "BFGHKNORT"), new AggregationNicCategoryCombination('F', "BDGHKNORT"),
            new AggregationNicCategoryCombination('G', "BKNRT"), new AggregationNicCategoryCombination('J', "QLSV"),
            new AggregationNicCategoryCombination('Q', "LSV"), new AggregationNicCategoryCombination('L', "SV"),
            new AggregationNicCategoryCombination('N', "BHT"), new AggregationNicCategoryCombination('O', "BGKT"),
            new AggregationNicCategoryCombination('R', "BHNT"), new AggregationNicCategoryCombination('S', "V"),
            new AggregationNicCategoryCombination('T', "B")};

    @Override
    protected Map<Character, AggregationNicCategoryCombination> getAggregationCases() {
        return toMap(NIC_CATEGORY_COMBINATIONS_0607);
    }

}
