/*
 * Created on 07-Jan-2006
 *
 * $Id: AggregationC.java,v 1.1 2006/06/08 13:49:07 dec Exp $
 */
package paye.eoy.bizrules.p14.aggregation;

import java.util.Map;

/**
 * Aggregation for 0708 to 1112
 */
class AggregationD extends AbstractAggregation {

    // The NI Category combinations for 0708 are the same as for 0607. Only the
    // earnings combinations (the table above) have changed.
    private static final AggregationNicCategoryCombination[] NIC_CATEGORY_COMBINATIONS_0708 = AggregationC.NIC_CATEGORY_COMBINATIONS_0607;

    public static final AggregationEarningsCombination[] AGGREGATION_EARNINGS_COMBINATIONS = new AggregationEarningsCombination[] {
            new AggregationEarningsCombination("NNN", "YYN"), new AggregationEarningsCombination("NNY", "YNN"),
            new AggregationEarningsCombination("NNY", "YNY"), new AggregationEarningsCombination("NYY", "YNN"),
            new AggregationEarningsCombination("NYY", "YNY"),
            new AggregationEarningsCombination("NNY", "YYN"),
            new AggregationEarningsCombination("NNN", "YNY"),
            new AggregationEarningsCombination("NNN", "YNN"),
            new AggregationEarningsCombination("NNN", "NYN"),
            new AggregationEarningsCombination("NNN", "YYY"),
            // the following is the inverse of the above
            new AggregationEarningsCombination("YYN", "NNN"), new AggregationEarningsCombination("YNN", "NNY"),
            new AggregationEarningsCombination("YNY", "NNY"), new AggregationEarningsCombination("YNN", "NYY"),
            new AggregationEarningsCombination("YNY", "NYY"), new AggregationEarningsCombination("YYN", "NNY"),
            new AggregationEarningsCombination("YNY", "NNN"), new AggregationEarningsCombination("YNN", "NNN"),
            new AggregationEarningsCombination("NYN", "NNN"), new AggregationEarningsCombination("YYY", "NNN") };

    @Override
    protected Map<Character, AggregationNicCategoryCombination> getAggregationCases() {
        return toMap(NIC_CATEGORY_COMBINATIONS_0708);
    }

    /**
     * In 0708 a new aggregation combination was added to the rules.
     */
    @Override
    protected AggregationEarningsCombination[] getEarningsCombinations() {
        return AGGREGATION_EARNINGS_COMBINATIONS;
    }

}
