/*
 * Created on 07-Jan-2006
 *
 * $Id: AggregationC.java,v 1.1 2006/06/08 13:49:07 dec Exp $
 */
package paye.eoy.bizrules.p14.aggregation;

import java.util.Map;

/**
 * Aggregation from 1213
 */
class AggregationE extends AbstractAggregation {

    static final AggregationNicCategoryCombination[] NIC_CATEGORY_COMBINATIONS_1213 = new AggregationNicCategoryCombination[] {
            new AggregationNicCategoryCombination('A', "BDENORT"),
            new AggregationNicCategoryCombination('D', "BENORT"), new AggregationNicCategoryCombination('E', "BNORT"),
            new AggregationNicCategoryCombination('J', "QL"), new AggregationNicCategoryCombination('Q', "L"),
            new AggregationNicCategoryCombination('N', "BT"), new AggregationNicCategoryCombination('O', "BT"),
            new AggregationNicCategoryCombination('R', "BNT"), new AggregationNicCategoryCombination('T', "B") };

    @Override
    protected Map<Character, AggregationNicCategoryCombination> getAggregationCases() {
        return toMap(NIC_CATEGORY_COMBINATIONS_1213);
    }

    /**
     * Same as previous year. Only the NIC category combination table has
     * changed.
     */
    @Override
    protected AggregationEarningsCombination[] getEarningsCombinations() {
        return AggregationD.AGGREGATION_EARNINGS_COMBINATIONS;
    }

}
