package paye.eoy.bizrules.p14.aggregation;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.Nic;

/**
 * @author Doug
 * @since 13/7/2010
 */
public abstract class EarningsLELtoPTRuleAggregation extends AbstractAggregationRule {
    public static final String PT_TO_UAP_ZERO = "PT to UAP zero";

    private final String[] subcodes = { PT_TO_UAP_ZERO };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public EarningsLELtoPTRuleAggregation() {
        setRuleName("EarningsLELtoPTRule");
    }

    @Override
    protected void processRule(final Nic nic) {
        final BigDecimal aboveET = nic.getContributionLineC();
        final BigDecimal lelToEt = nic.getContributionLineB();

        if (getTableCodes().indexOf(nic.getNiCategory().charValue()) != -1) {
            if (aboveET != null) {
                if (aboveET.compareTo(BigDecimalUtil.ZERO) > 0 && lelToEt.compareTo(BigDecimalUtil.ZERO) <= 0) {
                    raiseError(PT_TO_UAP_ZERO, lelToEt);
                }
            }
        }
    }

    protected abstract String getTableCodes();

    @Override
    protected final void initializeLocalValueBindings() {
        // do nothing
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void localReset() {
        // do nothing
    }

}
