/*
 * Created on May 25, 2005
 * 
 * $Id: AbstractEarningsAtLELAggregationRule.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.br0405.atLEL;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.aggregation.AbstractAggregationRule;
import paye.eoy.types.Nic;

/**
 * 
 */
public abstract class AbstractEarningsAtLELAggregationRule extends AbstractAggregationRule {

    public static final String MUST_BE_GREATER_THAN_ZERO_FOR_CODE = "8";

    private final String[] subcodes = { MUST_BE_GREATER_THAN_ZERO_FOR_CODE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractEarningsAtLELAggregationRule() {
        setRuleName("EarningsAtLELRule");
    }

    protected abstract void processLocalRule(Nic nic);

    @Override
    protected void processRule(final Nic nic) {
        processLocalRule(nic);

        final Character niCategory = nic.getNiCategory();
        final BigDecimal AtLEL = nic.getContributionLineA();

        if (getTableCodes().indexOf(niCategory.charValue()) != -1 && AtLEL.compareTo(BigDecimalUtil.ZERO) <= 0) {
            raiseError(MUST_BE_GREATER_THAN_ZERO_FOR_CODE, AtLEL);
        }
    }

    protected abstract String getTableCodes();

    @Override
    protected void localReset() {
        // do nothing
    }

    @Override
    public void initializeLocalValueBindings() {
        // do nothing
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }
}