/*
 * Created on May 25, 2005
 * 
 * $Id: AbstractEarningsAtLELRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.br0405.atLEL;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class AbstractEarningsAtLELRule extends AbstractP14BusinessRule {
    public static final String MUST_BE_ZERO_FOR_TABLE_CODE = "must be 0 for table code";

    private final String[] subcodes = { MUST_BE_ZERO_FOR_TABLE_CODE, DocumentError.FORMAT, DocumentError.MINVALUE,
            DocumentError.MAXVALUE, DocumentError.MANDATORY, DocumentError.BLANK, WholePoundsHelper.NOT_WHOLE_POUNDS };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    private String atLEL;

    private String nicCategory;

    public BigDecimal getAtLEL() {
        return BigDecimalUtil.toBigDecimal(atLEL);
    }

    public void setAtLEL(final String atLEL) {
        this.atLEL = atLEL;
    }

    public AbstractEarningsAtLELRule() {
        setRuleName("EarningsAtLELRule");
    }

    public void setNICs(final Attribute[] attribute) {
        for (final Attribute element : attribute) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                nicCategory = value;
            }
        }
    }

    @Override
    protected void reset() {
        nicCategory = "";
        atLEL = "";
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/NICs", "/IRenvelope/EndOfYearReturn/P14Amended/NICs" };
    }

    public void processRule() {
        if (!nicCategory.equals("") && getNICategoriesForWhichValueMustBeZero().indexOf(nicCategory) != -1
                && getAtLEL().compareTo(BigDecimalUtil.ZERO) != 0) {
            raiseError(MUST_BE_ZERO_FOR_TABLE_CODE, getAtLEL());
        }
    }

    protected abstract String getNICategoriesForWhichValueMustBeZero();

    @Override
    public void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/AtLEL", "AtLEL");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/AtLEL", "AtLEL");
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        final String[] errorHandlers = new String[] { "distinguishWholePoundsError", "handleError" };
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/AtLEL", errorHandlers);
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/AtLEL", errorHandlers);
    }
}
