package paye.eoy.bizrules.p14.br1213;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.aggregation.AbstractAggregationRule;
import paye.eoy.bizrules.p14.br1112.EarningsPTtoUAPRule;
import paye.eoy.types.Nic;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

import java.math.BigDecimal;

/**
 * Rule changed in 11/12 to drop what was subrule 5, the 32p check against Total
 * of Employees and Employers Contributions Payable and the earnings threshold
 * (ET) was renamed to primary threshold (PT)
 *
 * @author doug
 */
public class EarningsPTtoUAPRuleAggregation extends AbstractAggregationRule {

    public EarningsPTtoUAPRuleAggregation() {
        setRuleName(EarningsPTtoUAPRule.EARNINGS_PT_TO_UAP_RULE);
    }

    public static final String ECP16 = "ECP16";

    public static final String MUST_BE_GT_ZERO_IF_PT_TO_UAP = "must be greater than zero when PTtoUAP is greater than zero";

    private static final BigDecimal SIXTEEN_PENCE = new BigDecimal(0.16);


    @Override
    protected void processRule(final Nic nics) {
        if (getTableCodes().indexOf(nics.getNiCategory()) != -1 && getReturnType() == ReturnType.ORIGINAL) {
            checkSubrule5(nics);
            checkSubrule6(nics);
        }
    }

    private String getTableCodes() {
        return "ADEJLNOQR";
    }

    private void checkSubrule5(final Nic nics) {
        final BigDecimal ptToUAP = nics.getContributionLineC();
        if (nics.getEmp().compareTo(SIXTEEN_PENCE) > 0 && ptToUAP.compareTo(BigDecimalUtil.ZERO) <= 0) {
            raiseError(ECP16, ptToUAP);
        }
    }

    private void checkSubrule6(final Nic nics) {
        final BigDecimal ptToUAP = nics.getContributionLineC();
        if (nics.getUAPToUEL().compareTo(BigDecimalUtil.ZERO) > 0 && ptToUAP.compareTo(BigDecimalUtil.ZERO) <= 0) {
            raiseError(MUST_BE_GT_ZERO_IF_PT_TO_UAP, ptToUAP);
        }
    }

    @Override
    public String[] getSubcodes() {
        return new String[]{MUST_BE_GT_ZERO_IF_PT_TO_UAP, ECP16};
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void localReset() {
        // do nothing
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeLocalValueBindings() {
        // nothing to bind
    }

}
