/*
 * Created on May 25, 2005
 * 
 * $Id: AbstractEarningsETtoUELRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.nic;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import paye.eoy.types.ReturnType;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class AbstractEarningsAboveETRule extends AbstractP14BusinessRule {
    protected static final String ACTIVE_NI_CAT_LETTERS = "ADEFGHJKLNOQRSV";

    public static final String EARNINGS_ABOVE_ET_RULE = "EarningsAboveETRule";

    public static final String ECP16 = "ECP16";

    public static final String ECP32 = "ECP32";

    public static final String MUST_BE_ZERO_FOR_NI_CATEGORY = "must be zero for ni category";

    private final String[] subcodes = { MUST_BE_ZERO_FOR_NI_CATEGORY, ECP32, ECP16, DocumentError.FORMAT, DocumentError.BLANK,
            DocumentError.MANDATORY, DocumentError.MINVALUE, DocumentError.MAXVALUE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    private String niCategory;

    private static final BigDecimal SIXTEEN_PENCE = new BigDecimal(0.16);

    private static final BigDecimal THIRTY_TWO_PENCE = new BigDecimal(0.32);

    private BigDecimal earnings = BigDecimalUtil.ZERO;

    private BigDecimal both = BigDecimalUtil.ZERO;

    private BigDecimal emp = BigDecimalUtil.ZERO;

    public AbstractEarningsAboveETRule() {
        setRuleName(EARNINGS_ABOVE_ET_RULE);
    }

    public void setNICs(final Attribute[] attribute) {

        for (final Attribute element : attribute) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                setNiCategory(value);
            }
        }
    }

    @Override
    protected void initializeValueBindings() {

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Emp", "emp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Emp", "emp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Both", "both");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "both");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUEL", "earnings");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUEL", "earnings");

        /*
         * For 09/10 ETtoUAP has supplanted ETtoUEL
         */
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUAP", "earnings");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUAP", "earnings");

    }

    public void setEarnings(final String earnings) {
        this.setEarnings(BigDecimalUtil.toBigDecimal(earnings));
    }

    public void setEmp(final String emp) {
        this.emp = BigDecimalUtil.toBigDecimal(emp);
    }

    public void setBoth(final String both) {
        this.both = BigDecimalUtil.toBigDecimal(both);
    }

    @Override
    protected void reset() {
        setNiCategory("");
        setEarnings(BigDecimalUtil.ZERO);
        setEmp(BigDecimalUtil.ZERO);
        setBoth(BigDecimalUtil.ZERO);
    }

    public void processRule() {
        checkSubrule4();

        if (ACTIVE_NI_CAT_LETTERS.indexOf(getNiCategory()) != -1 && getReturnType() == ReturnType.ORIGINAL) {
            checkSubrule5();
            checkSubrule6();
        }
    }

    private void checkSubrule6() {
        if (getEmp().compareTo(SIXTEEN_PENCE) > 0 && getEarnings().compareTo(BigDecimalUtil.ZERO) <= 0) {
            raiseError(ECP16, getEarnings());
        }
    }

    private void checkSubrule5() {
        if (getBoth().compareTo(THIRTY_TWO_PENCE) > 0 && getEarnings().compareTo(BigDecimalUtil.ZERO) <= 0) {
            raiseError(ECP32, getEarnings());
        }
    }

    private void checkSubrule4() {
        if (getNICategoryForWhichValueMustBeZero().indexOf(getNiCategory()) != -1) {
            if (getEarnings().compareTo(BigDecimalUtil.ZERO) != 0) {
                raiseError(MUST_BE_ZERO_FOR_NI_CATEGORY, getEarnings());
            }
        }
    }

    protected abstract String getNICategoryForWhichValueMustBeZero();

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/NICs", "/IRenvelope/EndOfYearReturn/P14Amended/NICs" };
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    private void setEarnings(final BigDecimal ettoUEL) {
        this.earnings = ettoUEL;
    }

    protected BigDecimal getEarnings() {
        return earnings;
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUEL", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUEL", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUAP", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUAP", "handleError");
    }

    private void setEmp(final BigDecimal emp) {
        this.emp = emp;
    }

    private BigDecimal getEmp() {
        return emp;
    }

    private void setBoth(final BigDecimal both) {
        this.both = both;
    }

    private BigDecimal getBoth() {
        return both;
    }

    protected void setNiCategory(final String niCategory) {
        this.niCategory = niCategory;
    }

    protected String getNiCategory() {
        return niCategory;
    }
}
