/*
 * Created on May 25, 2005
 * 
 * $Id: AbstractEarningsLELtoETRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.nic;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.helpers.WholePoundsHelper;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class AbstractEarningsLELtoETRule extends AbstractP14BusinessRule {

    public static final String MUST_BE_ZERO_FOR_NI_CATEGORY = "6";

    private final String[] subcodes = { MUST_BE_ZERO_FOR_NI_CATEGORY, DocumentError.FORMAT, DocumentError.BLANK,
            DocumentError.MANDATORY, DocumentError.MINVALUE, DocumentError.MAXVALUE, DocumentError.UNKNOWN,
            DocumentError.ATTRIBUTE, DocumentError.VALUE, WholePoundsHelper.NOT_WHOLE_POUNDS };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    private static final BigDecimal ZERO = new BigDecimal(0.0);

    private BigDecimal lelToET = BigDecimalUtil.ZERO;

    private String niCategory = "";

    public AbstractEarningsLELtoETRule() {
        setRuleName("EarningsLELtoETRule");
    }

    public void setLELtoET(final String value) {
        lelToET = BigDecimalUtil.toBigDecimal(value);
    }

    public void setNICs(final Attribute[] attribute) {
        for (final Attribute element : attribute) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                niCategory = value;
            }
        }
    }

    @Override
    protected final void initializeValueBindings() {

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/LELtoET", "LELtoET");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/LELtoET", "LELtoET");

    }

    public void processRule() {
        if (niCategory.length() > 0 && getNICategoryForWhichValueMustBeZero().indexOf(niCategory) != -1) {
            if (lelToET.compareTo(ZERO) != 0) {
                raiseError(MUST_BE_ZERO_FOR_NI_CATEGORY, lelToET);
            }
        }
    }

    protected abstract String getNICategoryForWhichValueMustBeZero();

    @Override
    protected void reset() {
        lelToET = BigDecimalUtil.ZERO;
        niCategory = "";
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/NICs", "/IRenvelope/EndOfYearReturn/P14Amended/NICs" };
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        final String[] errorHandlers = new String[] { "distinguishWholePoundsError", "handleError" };
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Earn/LELtoET", errorHandlers);
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/LELtoET", errorHandlers);
    }
}
