/*
 * Created on May 26, 2005
 *
 * $Id: AbstractEmployeesContributionsPayableRuleOriginal.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.types.ReturnType;

/**
 * @author Rob
 */
public abstract class AbstractEmployeesContributionsPayableRuleOriginal extends AbstractSimpleNicRule {

    public static final String BOTH = "both";

    private final String[] subcodes = { BOTH };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractEmployeesContributionsPayableRuleOriginal() {
        setRuleName("EmployeesContributionsPayableRule");
    }

    public final void processRule() {
        processLocalRule();

        if ("ABJRTQ".indexOf(getNiCategory()) != -1 && getEmp().compareTo(getBoth()) > 0) {
            raiseError(BOTH, getEmp());
        }
    }

    protected abstract void processLocalRule();

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }
}
