/*
 * Created on 30-May-2005
 *
 * $Id: AbstractNicTotal.java,v 1.2 2006/08/10 15:19:16 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.bizrules.qs3.AbstractTotalRule;
import xmldoc.Attribute;

/**
 * 
 */
public abstract class AbstractNicTotal extends AbstractTotalRule {

    private String nicTab = "";

    public void setNicTab(final Attribute[] attributes) {

        for (final Attribute element : attributes) {

            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                nicTab = value;
            }
        }
    }

    protected String getNicTab() {
        return nicTab;
    }

    @Override
    protected final void initializeValueBindings() {
        initializeSuppliedTotalBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "nicTab");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "nicTab");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Both", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "value");
    }

    abstract protected void initializeSuppliedTotalBindings();
}
