/*
 * Created on 15-Jan-2006
 *
 * $Id: AbstractSimpleNicRule.java,v 1.2 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p14.nic;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import xmldoc.Attribute;

/**
 * $Id: AbstractSimpleNicRule.java,v 1.2 2006/08/10 15:19:16 dec Exp $
 */
public abstract class AbstractSimpleNicRule extends AbstractP14BusinessRule {

    private String niCategory = "";

    private BigDecimal both = BigDecimalUtil.ZERO;

    private BigDecimal emp = BigDecimalUtil.ZERO;

    protected abstract void localReset();

    @Override
    protected final void reset() {
        niCategory = "";
        both = BigDecimalUtil.ZERO;
        emp = BigDecimalUtil.ZERO;
        localReset();
    }

    public final void setNICs(final Attribute[] attributes) {

        for (final Attribute element : attributes) {
            if ("Tab".equals(element.getLocalName())) {
                final String value = element.getValue();

                niCategory = value;
            }
        }
    }

    protected abstract void initializeLocalValueBindings();

    @Override
    protected final void initializeValueBindings() {
        initializeLocalValueBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Both", "Both");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "Both");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs/Emp", "Emp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Emp", "Emp");
    }

    public final void setBoth(final String both) {
        this.both = BigDecimalUtil.toBigDecimal(both);
    }

    public final void setEmp(final String emp) {
        this.emp = BigDecimalUtil.toBigDecimal(emp);
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14/NICs", "/IRenvelope/EndOfYearReturn/P14Amended/NICs" };
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    protected final String getNiCategory() {
        return niCategory;
    }

    protected final BigDecimal getBoth() {
        return both;
    }

    protected final BigDecimal getEmp() {
        return emp;
    }

}
